<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('transactions', function (Blueprint $table) {
            // For systems like UltimatePOS, purchases live in `transactions` with type='purchase'
            $table->enum('purchase_mode', ['cash','consignment'])
                  ->default('cash')
                  ->after('payment_status'); // adjust position if you like
        });
    }

    public function down(): void
    {
        Schema::table('transactions', function (Blueprint $table) {
            $table->dropColumn('purchase_mode');
        });
    }
};
